function visImg = visualizeSegmentation(img_rgb, segmentedImage, figTitle)
%VISUALIZESEGMENTATION Visualize segmented image in a user-friendly way
%
%   Input:
%       img_rgb       : original image RGB channels
%       segmentedImage: binary image with output segmentation
%       figTitle      : title for the visualization figure
% 
%   Output:
%       visImg: RGB image with nice segmentation visualization
%
% (c) Moustafa Meshry, moustafa.meshry@alexu.edu.eg
%     Department of Compter and Systems Engineering, Alexandria University, Egypt.

    segImageMask = segmentedImage ~= 0;
    
    r = img_rgb(:,:,1);
    g = img_rgb(:,:,2);
    b = img_rgb(:,:,3);
    
    kMaxIter = 1;
    
    %% foreground
    
    tmpImgMask = segImageMask;
    boundary = bwperim(tmpImgMask, 8);
    [height, width] = size(tmpImgMask);
    boundary(1, :) = 0;
    boundary(height, :) = 0;
    boundary(:, 1) = 0;
    boundary(:, width) = 0;
    for i = 1 : kMaxIter
        tmpImgMask(boundary) = 0;
        boundary = boundary | bwperim(tmpImgMask, 8);
        boundary(1, :) = 0;
        boundary(height, :) = 0;
        boundary(:, 1) = 0;
        boundary(:, width) = 0;
    end
    
    r(boundary) = 0;
    g(boundary) = 255;
    b(boundary) = 0;

    %% background
    
    tmpImgMask = ~segImageMask;
    boundary = bwperim(tmpImgMask, 8);
    [height, width] = size(tmpImgMask);
    boundary(1, :) = 0;
    boundary(height, :) = 0;
    boundary(:, 1) = 0;
    boundary(:, width) = 0;
    for i = 1 : kMaxIter
        tmpImgMask(boundary) = 0;
        boundary = boundary | bwperim(tmpImgMask, 8);
        boundary(1, :) = 0;
        boundary(height, :) = 0;
        boundary(:, 1) = 0;
        boundary(:, width) = 0;
    end
    
    r(boundary) = 255;
    g(boundary) = 0;
    b(boundary) = 0;

    visImg = cat(3, r, g, b);
    if (nargin > 2)
        figure('Name', figTitle);
    else
        figure;
        figTitle = '';
    end
    imshow(visImg);
    title(figTitle);

end

